package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.PersonTask;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.RequestWorkflow;
import gov.va.vinci.dart.biz.TaskAging;
import gov.va.vinci.dart.db.PersonTaskDAO;
import gov.va.vinci.dart.service.DartObjectFactory;

public class PersonTaskDAOMock implements PersonTaskDAO {

	private static boolean initialized = false;
	private static final HashMap<Integer,PersonTask> IDHash = new HashMap<Integer,PersonTask>();
	
	@Override
	public void save(PersonTask personTask) {

		initializeTaskHash();

		// have TaskDAO allocate an Id to the task
		DartObjectFactory.getInstance().getTaskDAO().save(personTask);
		
		// and save it in our hash
		IDHash.put(personTask.getId(), personTask);
	}
	
	@Override
	public void delete(PersonTask personTask) {
		initializeTaskHash();

		//remove this task from the hash
		IDHash.remove(personTask.getId());
	}
	
	
	@Override
	public PersonTask findById(int taskId) {
		initializeTaskHash();
		
		return IDHash.get(taskId);
	}

	@Override
	public List<PersonTask> listByOwner(int ownerId) {
		initializeTaskHash();
		
		List<PersonTask> result = new ArrayList<PersonTask>();

		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				PersonTask pt = IDHash.get(id);
				if (ownerId == pt.getPersonOwner().getId()) {
					result.add(pt);
				}
			}
		}
		
		return result;
	}

	@Override
	public List<PersonTask> listOpenByOwner(int ownerId) {
		initializeTaskHash();
		
		List<PersonTask> result = new ArrayList<PersonTask>();
		
		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				PersonTask pt = IDHash.get(id);
				if (ownerId == pt.getPersonOwner().getId() && pt.getCompletedOn() == null) {
					result.add(pt);
				}
			}
		}
		
		return result;
	}

	@Override
	public List<PersonTask> listOpenByRequestId(int requestId) {
		initializeTaskHash();
		
		List<PersonTask> result = new ArrayList<PersonTask>();
		
		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				PersonTask pt = IDHash.get(id);
				if (requestId == pt.getRequest().getId() && pt.getCompletedOn() == null) {
					result.add(pt);
				}
			}
		}
		
		return result;
	}

		
	@Override
	public List<PersonTask> listOpenByWorkflowAndRequestId(final int workflowId, final int requestId) {
		initializeTaskHash();
		
		List<PersonTask> result = new ArrayList<PersonTask>();
		
		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				PersonTask pt = IDHash.get(id);
				if (requestId == pt.getRequest().getId() && pt.getCompletedOn() == null) {
					
					if( pt.getWorkflow() != null && pt.getWorkflow().getId() == workflowId ) {	//get the PersonTasks for this workflow
						result.add(pt);
					}//end if

				}
			}
		}
		
		return result;
	}

	
	@Override
	public TaskAging getTaskAging(int ownerId) {
		initializeTaskHash();

		return new TaskAging(1, 2, 3, 4);
	}

	@Override
	public List<PersonTask> listAllPersonTasks() {
		initializeTaskHash();
		
		List<PersonTask> result = new ArrayList<PersonTask>();
		
		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				result.add(IDHash.get(id));
			}
		}
		
		return result;
	}

	@Override
	public List<PersonTask> listAllOpenPersonTasks() {
		initializeTaskHash();
		
		List<PersonTask> result = new ArrayList<PersonTask>();
		
		if (IDHash.size() > 0) {
			for (Integer id: IDHash.keySet()) {
				PersonTask pt = IDHash.get(id);
				if (pt.getCompletedOn() == null) {
					result.add(pt);
				}
			}
		}
		
		return result;
	}

	private void initializeTaskHash() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;
	
		try {
			initializeTaskHash0();
		}
		catch (ObjectNotFoundException e) {
			e.printStackTrace();
		}
		catch (ValidationException e) {
			e.printStackTrace();
		}
	}
	
	private void initializeTaskHash0() throws ObjectNotFoundException, ValidationException {
		DartObjectFactory.getInstance().getResearchStudyDAO().listAll();  // to initialize

		List<DartRequest> rList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Request request = rList.get(0);
		Person owner = DartObjectFactory.getInstance().getPersonDAO().findById(1004);

		RequestWorkflow workflow = null;
		List<RequestWorkflow> wList = DartObjectFactory.getInstance().getRequestWorkflowDAO().listAll();
		if( wList != null && wList.size() > 0 ) {
			workflow = wList.get(0);
		}
		
		PersonTask.create(workflow, request, owner, "test person task 1", "test person task 1", owner.getName());
	}

}
